/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.hiscore;

import java.util.Set;
import lombok.Generated;
import net.runelite.api.WorldType;
import okhttp3.HttpUrl;

public enum HiscoreEndpoint {
    NORMAL("Normal", "https://hiscores.soul-wild.org?mode=normal"),
    IRONMAN("Ironman", "https://hiscores.soul-wild.org?mode=ironman"),
    HARDCORE_IRONMAN("Hardcore Ironman", "https://hiscores.soul-wild.org?mode=hardcore_ironman"),
    ULTIMATE_IRONMAN("Ultimate Ironman", "https://hiscores.soul-wild.org?mode=ultimate_ironman"),
    DEADMAN("Deadman", "https://hiscores.soul-wild.org?mode=deadman"),
    LEAGUE("Leagues", "https://hiscores.soul-wild.org?mode=seasonal"),
    TOURNAMENT("Tournament", "https://hiscores.soul-wild.org?mode=tournament"),
    FRESH_START_WORLD("Fresh Start", "https://hiscores.soul-wild.org?mode=fresh_start"),
    PURE("1 Defence Pure", "https://hiscores.soul-wild.org?mode=skiller_defence"),
    LEVEL_3_SKILLER("Level 3 Skiller", "https://hiscores.soul-wild.org?mode=skiller");

    private final String name;
    private final HttpUrl hiscoreURL;

    private HiscoreEndpoint(String name, String hiscoreURL) {
        this.name = name;
        this.hiscoreURL = HttpUrl.get(hiscoreURL);
    }

    public static HiscoreEndpoint fromWorldTypes(Set<WorldType> worldTypes) {
        if (worldTypes.contains((Object)WorldType.SEASONAL)) {
            return LEAGUE;
        }
        if (worldTypes.contains((Object)WorldType.TOURNAMENT_WORLD)) {
            return TOURNAMENT;
        }
        if (worldTypes.contains((Object)WorldType.DEADMAN)) {
            return DEADMAN;
        }
        if (worldTypes.contains((Object)WorldType.FRESH_START_WORLD)) {
            return FRESH_START_WORLD;
        }
        return NORMAL;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public HttpUrl getHiscoreURL() {
        return this.hiscoreURL;
    }
}

