/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.cannon;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.inject.Inject;
import lombok.Generated;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.cannon.CannonConfig;
import net.runelite.client.plugins.cannon.CannonPlugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;

class CannonSpotOverlay
extends Overlay {
    private final Client client;
    private final CannonPlugin plugin;
    private final CannonConfig config;
    @Inject
    private ItemManager itemManager;
    private boolean hidden;

    @Inject
    CannonSpotOverlay(Client client2, CannonPlugin plugin, CannonConfig config) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.client = client2;
        this.plugin = plugin;
        this.config = config;
    }

    @Override
    public Dimension render(Graphics2D graphics) {
        List<WorldPoint> spotPoints = this.plugin.getSpotPoints();
        if (this.hidden || spotPoints.isEmpty() || !this.config.showCannonSpots() || this.plugin.isCannonPlaced()) {
            return null;
        }
        for (WorldPoint spot : spotPoints) {
            if (spot.getPlane() != this.client.getPlane()) continue;
            LocalPoint spotPoint = LocalPoint.fromWorld(this.client, spot);
            LocalPoint localLocation = this.client.getLocalPlayer().getLocalLocation();
            if (spotPoint == null || localLocation.distanceTo(spotPoint) > 4100) continue;
            this.renderCannonSpot(graphics, this.client, spotPoint, this.itemManager.getImage(2), Color.RED);
        }
        return null;
    }

    private void renderCannonSpot(Graphics2D graphics, Client client2, LocalPoint point, BufferedImage image, Color color) {
        Point imageLoc;
        Polygon poly = Perspective.getCanvasTilePoly(client2, point);
        if (poly != null) {
            OverlayUtil.renderPolygon(graphics, poly, color);
        }
        if ((imageLoc = Perspective.getCanvasImageLocation(client2, point, image, 0)) != null) {
            OverlayUtil.renderImageLocation(graphics, imageLoc, image);
        }
    }

    @Generated
    void setHidden(boolean hidden) {
        this.hidden = hidden;
    }
}

