/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.ping;

import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.ping.PingPanel;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.util.ImageUtil;

@PluginDescriptor(name="Ping", description="Measures your current ping")
public final class PingPlugin
extends Plugin {
    @Inject
    private ClientToolbar clientToolbar;
    private PingPanel panel;
    private NavigationButton navButton;

    @Override
    protected void startUp() throws Exception {
        this.panel = this.injector.getInstance(PingPanel.class);
        this.panel.init();
        BufferedImage icon = ImageUtil.loadImageResource(this.getClass(), "ping_icon.png");
        this.navButton = NavigationButton.builder().tooltip("Ping").icon(icon).priority(9).panel(this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
    }

    @Override
    protected void shutDown() throws Exception {
        this.panel.deinit();
        this.panel = null;
        this.clientToolbar.removeNavigation(this.navButton);
        this.navButton = null;
    }
}

