/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.ping;

import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PingThread
extends Thread {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PingThread.class);
    private final long intervalMs;
    private final Runnable runnable;
    private volatile boolean running = false;

    PingThread(long intervalMs, Runnable runnable) {
        super(PingThread.class.getSimpleName());
        this.setDaemon(true);
        this.setPriority(4);
        this.intervalMs = intervalMs;
        this.runnable = runnable;
    }

    @Override
    public void run() {
        while (this.running && !Thread.interrupted()) {
            try {
                long start = System.nanoTime();
                this.runnable.run();
                long end = System.nanoTime();
                long elapsed = end - start;
                long elapsedMs = TimeUnit.NANOSECONDS.toMillis(elapsed);
                long sleepMs = this.intervalMs - elapsedMs;
                if (sleepMs <= 0L) continue;
                try {
                    PingThread.sleep(sleepMs);
                }
                catch (InterruptedException e) {
                    log.error("Ping thread interrupted", e);
                    return;
                }
            }
            catch (Exception e) {
                log.error("Error in ping thread", e);
            }
        }
    }

    @Generated
    public void setRunning(boolean running) {
        this.running = running;
    }

    @Generated
    public boolean isRunning() {
        return this.running;
    }
}

