/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.ping;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;

final class TotalPing {
    private static final int PING_OPCODE = 200;
    private static final int EXPECTED_RESPONSE_VALUE = 201;
    private volatile Socket socket;

    TotalPing() {
    }

    long ping(String host, int port, int timeout) throws Exception {
        try {
            Socket socket = this.socket;
            if (socket == null || socket.isClosed() || !socket.isConnected()) {
                this.socket = socket = new Socket();
                socket.setSoTimeout(timeout);
                socket.setTcpNoDelay(true);
                socket.setReceiveBufferSize(65536);
                socket.setSendBufferSize(65536);
                socket.connect(new InetSocketAddress(host, port));
            }
            OutputStream out = socket.getOutputStream();
            InputStream in = socket.getInputStream();
            long start = System.nanoTime();
            out.write(200);
            out.flush();
            int response = in.read() & 0xFF;
            long end = System.nanoTime();
            if (response != 201) {
                throw new IllegalStateException("Unexpected ping response " + response + " (expected 201)");
            }
            return end - start;
        }
        catch (Exception e) {
            Socket socket = this.socket;
            this.socket = null;
            if (socket != null) {
                socket.close();
            }
            throw e;
        }
    }
}

